//Exp 14 Program Title:To Perform Wavelet Transform on grayscale image 
//environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Toolbox:wavlab 1.0.1                                              
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all; //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
ii1=imread(SIVP_PATH + 'images/rose.bmp');//read  color image from diractory
r= rgb2gray(ii1); 
im=double(r);  
[a,b,c,d]=dwt2(im,'db2');//WavelabToolbox
[a1,b1,c1,d1]=dwt2(a,'db2');//WavelabToolbox
figure(1);ShowImage(im,'Grayscale image');title('Grayscale image','color','red','fontsize',4);//IPDtoolbox
figure(2);ShowImage(a,'LL Component at 1st Level');title('LL Component at 1st Level','color','red','fontsize',4);//IPDtoolbox
figure(3);ShowImage(b,'LH Component at 1st Level');title('LH Component at 1st Level','color','red','fontsize',4);//IPDtoolbox
figure(4);ShowImage(c,'HL Component at 1st Level');title('HL Component at 1st Level','color','red','fontsize',4);//IPDtoolbox
figure(5);ShowImage(d,'HH Component at 1st Level');title('HH Component at 1st Level','color','red','fontsize',4);//IPDtoolbox
figure(6);ShowImage(a1,' 2nd Level Decomposition');title('2nd Level Decomposition','color','red','fontsize',4);//IPDtoolbox
figure(7);ShowImage(b1,' 2nd Level Decomposition');title('2nd Level Decomposition','color','red','fontsize',4);//IPDtoolbox
figure(8);ShowImage(c1,' 2nd Level Decomposition');title('2nd Level Decomposition','color','red','fontsize',4);//IPDtoolbox
figure(9);ShowImage(d1,' 2nd Level Decomposition');title('2nd Level Decomposition','color','red','fontsize',4);//IPDtoolbox

